function [fitresult, gof] = Create_Surface_Fit_3(global_x_r_log, global_y_r_log, global_f_r_log)
%CREATESURFACEFIT(GLOBAL_X_R_LOG,GLOBAL_Y_R_LOG,GLOBAL_F_R_LOG)
%  Fit surface to data.
%
%  Data for 'untitled fit 1' fit:
%      X Input : global_x_r_log
%      Y Input : global_y_r_log
%      Z Output: global_f_r_log
%  Output:
%      fitresult : an sfit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, SFIT.

%  Auto-generated by MATLAB on 06-Apr-2011 23:58:09


%% Fit: 'untitled fit 1'.
[xInput, yInput, zOutput] = prepareSurfaceData( global_x_r_log, global_y_r_log, global_f_r_log );

% Set up fittype and options.
ft = fittype( 'biharmonicinterp' );
opts = fitoptions( ft );
opts.Normalize = 'on';

% Fit model to data.
[fitresult, gof] = fit( [xInput, yInput], zOutput, ft, opts );

% Plot fit with data.
figure( 'Name', 'untitled fit 1' );
h = plot( fitresult, [xInput, yInput], zOutput );
legend( h, 'untitled fit 1', 'global_f_r_log vs. global_x_r_log, global_y_r_log', 'Location', 'NorthEast' );
% Label axes
xlabel( 'global_x_r_log' );
ylabel( 'global_y_r_log' );
zlabel( 'global_f_r_log' );
grid on
view( -56.5, 18 );


